SELECT     dbo.v_BehaviorDetail.personID as district_student_id, 'suspension' as category, 
cast(COUNT(dbo.v_BehaviorDetail.eventID) as varchar) 
+ ' behavior event(s) in the current year' as reason


FROM         dbo.v_BehaviorDetail INNER JOIN
                      dbo.Calendar ON dbo.v_BehaviorDetail.calendarID = dbo.Calendar.calendarID INNER JOIN
                      dbo.SchoolYear ON dbo.Calendar.endYear = dbo.SchoolYear.endYear
WHERE     (dbo.v_BehaviorDetail.resolutionCode IN 
('OS', 'IS', 'OTHERCODESHERE') -- put categories here in '', separated by commas
) 
AND (dbo.Schoolyear.active=1)
GROUP BY dbo.v_BehaviorDetail.personID
having COUNT(dbo.v_BehaviorDetail.eventID) >=2  --At least 2 incidents in the above categories will generate a flag